//
//  DHDSACNConstants.h
//  DHDMX
//
//  Created by Douglas Heriot on 3/03/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#include "DHDMXConstants.h"

#ifndef DHDMX_DHDSACNConstants_h
#define DHDMX_DHDSACNConstants_h

enum
{
	// Defined in spec, page 17 section 7.7.1 – shall not exceed DMX512-A limit of 512 slots
	SACN_DMX_MAX_LENGTH = DHDMX_UNIVERSE_LENGTH,
	
	SACN_UNIVERSE_MIN = 1,
	SACN_UNIVERSE_MAX = 63999,
	
	SACN_PRIORITY_MIN = 0,
	SACN_PRIORITY_DEFAULT = 100,
	SACN_PRIORITY_MAX = 200,
	
	SACN_SOURCE_NAME_LENGTH = 64,
};

#endif
